<?php

namespace App\Http\Livewire\Extensions\GloverWebsite\Livewire;

use App\Models\User;
use App\Models\WalletTransaction;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class MyWalletLivewire extends BaseLivewireComponent
{

    public $amount;

    public function mount()
    {
        $user = User::find(Auth::id());
        $user->createWallet();
    }

    public function render()
    {

        // Create the base query
        $baseQuery = WalletTransaction::whereHas("wallet", function ($q) {
            return $q->where("user_id", Auth::id());
        });

        // Clone the query for each specific use
        $lastCreditQuery = clone $baseQuery;
        $lastDebitQuery = clone $baseQuery;
        $paginationQuery = clone $baseQuery;

        // Execute each query for its specific purpose
        $lastCredit = $lastCreditQuery->where('is_credit', 1)->latest()->first();
        $lastDebit = $lastDebitQuery->where('is_credit', 0)->latest()->first();
        $walletTransactions = $paginationQuery->latest()->paginate(20);

        return view('livewire.extensions.glover-website.my-wallet', [
            'transactions' => $walletTransactions,
            'wallet' => Auth::user()->wallet,
            'lastCredit' => $lastCredit,
            'lastDebit' => $lastDebit,
        ])->layout('livewire.extensions.glover-website.layouts.app');
    }



    public function initiateWalletTopup()
    {
        $minAmount = setting('minimumTopupAmount', 100);
        $this->validate([
            "amount" => "required|numeric|min:" . $minAmount . "",
        ], [
            "amount.required" => __("Required"),
            "amount.numeric" => __("numeric"),
            "amount.min" => __("Minium amount of :amount is allowed for wallet topup", [
                "amount" => $minAmount,
            ]),
        ]);


        //
        try {
            DB::beginTransaction();
            $wallet = Auth::user()->wallet;
            $walletTransaction = new WalletTransaction();
            $walletTransaction->amount = $this->amount;
            $walletTransaction->wallet_id = $wallet->id;
            $walletTransaction->is_credit = 1;
            $walletTransaction->reason = __("Topup");
            $walletTransaction->ref = "tp_" . Str::random(10);
            $walletTransaction->status = "pending";
            $walletTransaction->payment_method_id = $request->payment_method_id ?? null;
            $walletTransaction->save();
            DB::commit();
            $link = route('wallet.topup', ["code" => $walletTransaction->ref]);
            $this->emit("payment_redirect", $link);
        } catch (\Exception $ex) {
            DB::rollback();
            $errorMessage = $ex->getMessage();
            $this->showErrorAlert($errorMessage);
        }
    }






    //misc.
    /**
     * Get the appropriate step attribute for currency input fields.
     *
     * @return string
     */
    public function getCurrencyStep(): string
    {
        $decimals = (int) setting('ui.currency.decimals', 2);
        return '0.' . str_pad('1', $decimals, '0', STR_PAD_LEFT);
    }
}
