@php
    $link = route('glover-website.product', [
        'id' => $product->id,
        'slug' => !empty($product->name) ? \Str::slug($product->name) : \Str::random(10),
    ]);
@endphp
<a href="{{ $link }}">
    <div x-data="{ imgClass: '' }">
        <div class="rounded-lg overflow-clip border border-gray-200 hover:shadow bg-zinc-50 h-full"
            x-on:mouseover="imgClass = 'scale-110'" x-on:mouseout="imgClass = ''">
            <div class='relative'>
                <img src="{{ $product->photo }}" alt="Product logo"
                    class="w-full h-32 object-contain ease-in-out duration-500" :class="imgClass" />

                {{-- discount tag --}}
                @if ($product->discount_price > 0)
                    <div
                        class="absolute top-5 ltr:left-0 rtl:right-0 bg-primary-500 text-theme px-2 py-1 rounded-md  ltr:rounded-l-none rtl:rounded-r-none">
                        <p class="text-xs font-semibold">
                            @php
                                $discountedPercentage = 0;
                                try {
                                    $discountedPercentage = round(
                                        (($product->price - $product->discount_price) / $product->price) * 100,
                                    );
                                } catch (\Execption $error) {
                                    logger('Execption', [$error]);
                                }
                            @endphp
                            ~
                            {{-- calculate the discount percentage between price and discount_price --}}
                            {{ $discountedPercentage }}%
                            {{ __('Off') }}
                        </p>
                    </div>
                @endif
            </div>

            <div class="w-full p-2">
                <p class="line-clamp-1 text-ellipsis text-sm font-medium">{{ $product->name }}</p>
                <p class="text-xxs text-gray-500 line-clamp-2 text-ellipsis min-h-[2rem]">
                    {{-- strip description of html tags --}}
                    {{ strip_tags($product->description) }}
                </p>
                <p class="text-xs text-gray-700 text-ellipsis">
                    {{ $product->capacity ?? 0 }}
                    {{ $product->unit }}
                </p>
                {{-- price --}}
                <p class="font-semibold text-sm break-all">
                    @if ($product->discount_price <= 0)
                        <span class="font-normal line-through"
                            style="font-size:10px;">{{ currencyFormat($product->price) }}</span>
                    @endif
                    <span>{{ currencyFormat($product->sell_price) }}</span>
                </p>
                {{-- rating --}}
                @if (!$product->reviews->isEmpty())

                    <div>
                        @php
                            $maxRating = 5;
                            $currentRating = $product->rating ?? 0;
                        @endphp

                        {{-- rating --}}
                        <div class="flex space-x-1">
                            @for ($i = 1; $i <= $maxRating; $i++)
                                <x-tabler-star-filled
                                    class="w-3 h-3 {{ $i <= $currentRating ? 'text-amber-500' : 'text-gray-500' }}" />
                            @endfor
                        </div>
                    </div>
                @else
                    <p class="text-center italic text-xxs text-gray-400">{{ __('No Reviews yet') }}</p>
                @endif

            </div>
        </div>
    </div>
</a>
