@php
    $statusColor = config('backend.colors')[$order->status] ?? '#f0f0f0';
    // Generate UUID for the order details link
    $orderUuid = substr(md5('order_' . $order->code), 0, 8) . '-' .
                 substr(md5('order_' . $order->code), 8, 4) . '-' .
                 substr(md5('order_' . $order->code), 12, 4) . '-' .
                 substr(md5('order_' . $order->code), 16, 4) . '-' .
                 substr(md5('order_' . $order->code), 20, 12);
@endphp

<div class="bg-white p-4 rounded-lg shadow-md border border-gray-100 hover:bg-gray-50 mb-4">
    <div class="flex items-center justify-between">
        <div class="flex items-center flex-1">
            @if ($order->vendor)
                <img src="{{ $order->Vendor->logo }}" alt="" class="w-12 h-12 mr-3 rounded">
            @else
                <img src="{{ $order->taxi_order->vehicle_type->photo }}" alt="Product image"
                    class="w-12 h-12 mr-3 rounded">
            @endif
            <div class="flex-1">
                <div class="flex items-center justify-between">
                    <div>
                        <div class="font-semibold text-lg">#{{ $order->code }}</div>
                        <div class="text-gray-500 text-sm">
                            @if ($order->vendor)
                                {{ $order->vendor->name }}
                            @else
                                {{ $order->taxi_order->vehicle_type->name }} - {{ __('Taxi Order') }}
                            @endif
                        </div>
                        <div class="text-gray-400 text-xs">
                            {{ $order->created_at->format('M d, Y') }}
                        </div>
                    </div>

                    <div class="text-right">
                        <div class="font-semibold text-lg">{{ currencyFormat($order->total) }}</div>
                        <div class="flex items-center space-x-2 text-sm">
                            <span style="color: {{ $statusColor }}">{{ ucfirst($order->status) }}</span>
                            <span class="text-gray-400">•</span>
                            <span class="text-gray-500">{{ ucfirst($order->payment_status) }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="flex items-center justify-between mt-3 pt-3 border-t border-gray-100">
        <div class="flex items-center space-x-4">
            {{-- pay button if any --}}
            @if (
                !in_array($order->status, ['failed', 'cancelled']) &&
                    $order->payment_status == 'pending' &&
                    !empty($order->payment_link) &&
                    $order->payment_method->slug != 'cash')
                <a href="{{ $order->payment_link }}"
                    class="bg-primary-500 hover:bg-primary-600 text-white font-medium py-1 px-3 text-sm rounded-md inline-flex items-center space-x-1">
                    <x-heroicon-o-credit-card class="w-4 h-4" />
                    <span>{{ __('Pay') }}</span>
                </a>
            @endif
        </div>

        <a href="{{ route('glover-website.order.details', ['uuid' => $orderUuid]) }}"
            class="text-primary-600 hover:text-primary-800 font-medium text-sm inline-flex items-center space-x-1">
            <span>{{ __('View Details') }}</span>
            <x-heroicon-o-arrow-right class="w-4 h-4" />
        </a>
    </div>
</div>