<!DOCTYPE html>
<html :class="{ 'theme-dark': dark }" x-data="data()"
    lang="{{ Session::get('locale', env('WEBSITE_DEFAULT_LANGUAGE', config('app.locale'))) }}"
    dir="{{ isRTL() ? 'rtl' : 'ltr' }}">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="icon" type="image/png" href="{{ setting('favicon') }}" />
    <title>@yield('title', '') - {{ setting('websiteName', env('APP_NAME')) }}</title>
    <script src="{{ asset('js/extensions/glover-website/tailwindcss.js') }}"></script>
    <script src="{{ asset('js/extensions/glover-website/main.js') }}"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap"
        rel="stylesheet">
    @include('livewire.extensions.glover-website.includes.styles')
    @yield('styles')
    @stack('styles')
</head>

<body class="bg-gray-100">
    @include('livewire.extensions.glover-website.includes.header')
    @yield('extra-top-content')

    <main class="h-full min-h-[80vh] overflow-y-auto bg-gray-100">
        {{-- <div class="w-full md:w-[80vw] lg:w-[70vw] xl:w-[60vw] container grid px-6 py-5 mx-auto"> --}}
        <div class="w-full md:w-[80vw] xl:w-[70vw] container grid px-6 py-5 mx-auto">
            {{ $slot ?? '' }}
            @yield('content')
        </div>
    </main>

    <button class="fixed bottom-12 right-8 p-2 rounded-full border bg-gray-200 shadow border-gray-400"
        id="scrollButton">
        <x-heroicon-o-arrow-sm-up class="h-8 w-8" />
    </button>

    {{-- include --}}
    {!! setting('glover-website.inapp.support') !!}
    @include('livewire.extensions.glover-website.includes.footer')
    @include('layouts.partials.scripts')
    @stack('scripts')
    <script>
        const scrollButton = document.getElementById('scrollButton');
        // Function to check scroll position and toggle button visibility
        function toggleScrollButton() {
            const scrollTop = document.documentElement.scrollTop || document.body.scrollTop;
            const scrollHeight = document.documentElement.scrollHeight || document.body.scrollHeight;
            const clientHeight = document.documentElement.clientHeight || window.innerHeight;

            // Calculate 20% of the document height
            const triggerHeight = 0.2 * (scrollHeight - clientHeight);

            // Show or hide the button based on scroll position
            if (scrollTop > triggerHeight) {
                scrollButton.style.display = 'block';
            } else {
                scrollButton.style.display = 'none';
            }
        }
        // Attach the function to the window's scroll event
        window.addEventListener('scroll', toggleScrollButton);
        // Scroll to top when the button is clicked
        scrollButton.addEventListener('click', function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });
        // Initial check in case the user starts scrolled down
        toggleScrollButton();
    </script>
</body>

</html>
