@section('title', __('My Wallet'))
<div class="mb-20" x-data="{ isModalOpen: false }" @close-fund-modal.window="isModalOpen = false">
    {{-- breadcrumb --}}
    @include('livewire.extensions.glover-website.components.nav-breadcrumb', [
        'links' => [
            [
                'title' => __('Home'),
                'url' => route('glover-website.index'),
            ],
            [
                'title' => __('Wallet'),
                'url' => '',
            ],
        ],
    ])


    {{-- wallet info --}}
    <div class="mb-8">
        <!-- Wallet Summary Card -->
        <div class="bg-white rounded-lg shadow-md overflow-hidden">
            <!-- Balance Header -->
            <div class="bg-primary-600 px-6 py-4">
                <h2 class="text-xl font-bold text-theme">{{ __('My Wallet') }}</h2>
            </div>

            <!-- Balance Display -->
            <div class="px-6 py-6 border-b border-gray-200">
                <div class="flex flex-col md:flex-row md:items-center justify-between">
                    <div>
                        <p class="text-sm text-gray-500">{{ __('Available Balance') }}</p>
                        <p class="text-3xl font-bold text-gray-800">{{ currencyFormat($wallet->balance) }}</p>
                    </div>

                    <!-- Quick Actions -->
                    <div class="mt-4 md:mt-0 flex space-x-2">
                        <button class="px-4 py-2 bg-primary-500 text-theme rounded hover:bg-primary-600 transition"
                            @click="isModalOpen = true">
                            <span class="flex items-center">
                                <x-tabler-plus class="h-4 w-4 mr-1" />
                                {{ __('Fund Wallet') }}
                            </span>
                        </button>
                        {{-- <button class="px-4 py-2 bg-primary-500 text-white rounded hover:bg-primary-600 transition">
                            <span class="flex items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none"
                                    viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                                </svg>
                                {{ __('Withdraw') }}
                            </span>
                        </button> --}}
                    </div>
                </div>
            </div>

            <!-- Recent Transactions Summary -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 p-6">


                <!-- Last Credit -->
                <div class="bg-gray-50 p-4 rounded-lg border border-gray-200">
                    <div class="flex items-center mb-2">
                        <div class="h-8 w-8 rounded-full bg-green-100 flex items-center justify-center mr-3">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-green-600" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 4v16m8-8H4" />
                            </svg>
                        </div>
                        <h3 class="font-medium text-gray-800">{{ __('Last Credit') }}</h3>
                    </div>

                    @if ($lastCredit)
                        <div class="mt-2">
                            <p class="text-2xl font-semibold text-gray-800">{{ currencyFormat($lastCredit->amount) }}
                            </p>
                            <div class="flex justify-between mt-1">
                                <p class="text-xs text-gray-500">{{ $lastCredit->ref }}</p>
                                <p class="text-xs text-gray-500">{{ $lastCredit->created_at->diffForHumans() }}</p>
                            </div>
                        </div>
                    @else
                        <p class="text-sm text-gray-500 mt-2">{{ __('No credit transactions yet') }}</p>
                    @endif
                </div>

                <!-- Last Debit -->
                <div class="bg-gray-50 p-4 rounded-lg border border-gray-200">
                    <div class="flex items-center mb-2">
                        <div class="h-8 w-8 rounded-full bg-red-100 flex items-center justify-center mr-3">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-red-600" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6" />
                            </svg>
                        </div>
                        <h3 class="font-medium text-gray-800">{{ __('Last Debit') }}</h3>
                    </div>

                    @if ($lastDebit)
                        <div class="mt-2">
                            <p class="text-2xl font-semibold text-gray-800">{{ currencyFormat($lastDebit->amount) }}
                            </p>
                            <div class="flex justify-between mt-1">
                                <p class="text-xs text-gray-500">{{ $lastDebit->ref }}</p>
                                <p class="text-xs text-gray-500">{{ $lastDebit->created_at->diffForHumans() }}</p>
                            </div>
                        </div>
                    @else
                        <p class="text-sm text-gray-500 mt-2">{{ __('No debit transactions yet') }}</p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    {{-- transactions --}}
    <div class="mb-6">
        <!-- Desktop Table (hidden on mobile) -->
        <div class="hidden md:block overflow-x-auto">
            <table class="min-w-full bg-white divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            {{ __('S/N') }}
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            {{ __('Amount') }}
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            {{ __('Reference') }}
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            {{ __('Status') }}
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            {{ __('Type') }}
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            {{ __('Created At') }}
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            {{ __('Last Updated') }}
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach ($transactions as $key => $transaction)
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $key + 1 }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ currencyFormat($transaction->amount) }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $transaction->ref }}</td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span
                                    class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                            {{ $transaction->status == 'successful'
                                ? 'bg-green-100 text-green-800'
                                : ($transaction->status == 'failed'
                                    ? 'bg-red-100 text-red-800'
                                    : 'bg-zinc-100 text-zinc-600') }}">
                                    {{ ucfirst(__($transaction->status)) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span
                                    class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                            {{ $transaction->is_credit ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                    {{ __($transaction->is_credit ? 'Credit' : 'Debit') }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $transaction->created_at }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $transaction->updated_at }}
                            </td>
                        </tr>
                    @endforeach

                    @if (count($transactions) == 0)
                        <tr>
                            <td colspan="7" class="px-6 py-4 text-center text-gray-500">
                                {{ __('No transactions found') }}</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>

        <!-- Mobile Card View -->
        <div class="md:hidden space-y-4">
            @foreach ($transactions as $key => $transaction)
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
                    <div class="flex items-center justify-between p-4 border-b border-gray-200">
                        <span
                            class="inline-flex h-6 w-6 items-center justify-center rounded-full bg-gray-100 text-xs font-medium">
                            {{ $key + 1 }}
                        </span>
                        <div class="flex items-center space-x-2">
                            <span
                                class="px-2 py-1 text-xs font-semibold rounded-full
                            {{ $transaction->status == 'successful'
                                ? 'bg-green-100 text-green-800'
                                : ($transaction->status == 'failed'
                                    ? 'bg-red-100 text-red-800'
                                    : 'bg-zinc-100 text-zinc-600') }}">
                                {{ ucfirst(__($transaction->status)) }}
                            </span>
                            <span
                                class="px-2 py-1 text-xs font-semibold rounded-full
                            {{ $transaction->is_credit ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                {{ __($transaction->is_credit ? 'Credit' : 'Debit') }}
                            </span>
                        </div>
                    </div>

                    <div class="p-4 space-y-2">
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-500">{{ __('Amount') }}</span>
                            <span class="text-sm font-medium">{{ currencyFormat($transaction->amount) }}</span>
                        </div>

                        <div class="flex justify-between">
                            <span class="text-sm text-gray-500">{{ __('Reference') }}</span>
                            <span class="text-sm font-medium">{{ $transaction->ref }}</span>
                        </div>

                        <div class="flex justify-between">
                            <span class="text-sm text-gray-500">{{ __('Created') }}</span>
                            <span
                                class="text-sm font-medium">{{ $transaction->created_at->format('M d, Y H:i') }}</span>
                        </div>

                        <div class="flex justify-between">
                            <span class="text-sm text-gray-500">{{ __('Last Updated') }}</span>
                            <span
                                class="text-sm font-medium">{{ $transaction->updated_at->format('M d, Y H:i') }}</span>
                        </div>
                    </div>
                </div>
            @endforeach

            @if (count($transactions) == 0)
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6 text-center text-gray-500">
                    {{ __('No transactions found') }}
                </div>
            @endif
        </div>

        <div class="mt-4">
            {{ $transactions->links() }}
        </div>
    </div>

    {{-- amount entry modal --}}
    <div x-show="isModalOpen" class="fixed inset-0 z-50 overflow-y-auto"
        x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0"
        x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-200"
        x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" style="display: none;">

        <!-- Modal backdrop (no transform) -->
        <div class="fixed inset-0 bg-black bg-opacity-50" x-transition:enter="transition ease-out duration-200"
            x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
            x-transition:leave="transition ease-in duration-200" x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0" @click="isModalOpen = false">
        </div>

        <!-- Modal container -->
        <div class="flex items-center justify-center min-h-screen p-4">
            <!-- Modal content -->
            <div class="relative bg-white rounded-lg shadow-xl max-w-md w-full z-10"
                x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 transform scale-95"
                x-transition:enter-end="opacity-100 transform scale-100"
                x-transition:leave="transition ease-in duration-200"
                x-transition:leave-start="opacity-100 transform scale-100"
                x-transition:leave-end="opacity-0 transform scale-95" @click.away="isModalOpen = false"
                @keydown.escape.window="isModalOpen = false">

                <!-- Modal header -->
                <div class="flex items-center justify-between p-4 border-b">
                    <div>
                        <h3 class="text-lg font-medium text-gray-900">{{ __('Fund Your Wallet') }}</h3>
                        <p class="mt-1 text-sm text-gray-500">
                            {{ __('Enter the amount you want to credit your wallet with') }}</p>
                    </div>
                    <button @click="isModalOpen = false" class="text-gray-400 hover:text-gray-500 focus:outline-none">
                        <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </div>

                <!-- Modal body -->
                <div class="p-4">
                    <div class="mb-4">
                        <label for="amount"
                            class="block text-sm font-medium text-gray-700 mb-1">{{ __('Amount') }}</label>
                        <div class="relative mt-1 rounded-md shadow-sm">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <span class="text-gray-500 sm:text-sm">{{ setting('currency', '$') }}</span>
                            </div>
                            <input type="number" min="1" step="{{ $this->getCurrencyStep() }}"
                                name="amount" id="amount" wire:model.defer="amount"
                                class="focus:ring-primary-500 focus:border-primary-500 block w-full pl-8 pr-12 sm:text-sm border-gray-300 rounded-md"
                                placeholder="0.00" />
                            <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                <span class="text-gray-500 sm:text-sm">{{ setting('currencyCode', 'USD') }}</span>
                            </div>
                        </div>
                        @error('amount')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mt-4 bg-gray-50 p-3 rounded-md">
                        <div class="flex items-center">
                            <x-tabler-info-circle class="h-5 w-5 text-primary-500 mr-2" />
                            <span class="text-sm text-gray-700">
                                {{ __('Funds will be added to your wallet immediately after successful payment.') }}
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Modal footer -->
                <div class="p-4 border-t flex justify-end space-x-2">
                    <button @click="isModalOpen = false"
                        class="px-4 py-2 bg-gray-200 text-gray-800 rounded hover:bg-gray-300 transition focus:outline-none">
                        {{ __('Cancel') }}
                    </button>
                    <button wire:click="initiateWalletTopup"
                        class="px-4 py-2 bg-primary-500 text-theme rounded hover:bg-primary-600 transition focus:outline-none flex items-center">
                        <x-tabler-wallet class="h-4 w-4 mr-1" />
                        {{ __('Proceed to Payment') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
    {{-- loading --}}
    @include('livewire.extensions.glover-website.components.loading')
</div>
@push('scripts')
    <script>
        // Listen for the payment_redirect event
        livewire.on('payment_redirect', (link) => {
            // Open the payment link in a new tab
            window.open(link, '_blank');

            // Dispatch a custom event to close the modal
            window.dispatchEvent(new CustomEvent('close-fund-modal'));
        });
    </script>
@endpush
