@section('title', __('Order Details'))

<div class="min-h-screen pb-6" style="background: linear-gradient(135deg, #f9fafb 0%, #f3f4f6 100%);">
    {{-- breadcrumb --}}
    <div class="bg-white border-b">
        <div class="px-4 py-2">
            @include('livewire.extensions.glover-website.components.nav-breadcrumb', [
                'links' => [
                    [
                        'title' => __('Home'),
                        'url' => route('glover-website.index'),
                    ],
                    [
                        'title' => __('My Orders'),
                        'url' => route('glover-website.orders'),
                    ],
                    [
                        'title' => __('Order Details'),
                        'url' => '',
                    ],
                ],
            ])
        </div>
    </div>

    <div class="px-4 py-4">
        {{-- header section --}}
        <div class="bg-white rounded-2xl border border-gray-200 overflow-hidden mb-4">
            <div class="px-4 py-3" style="background: #f8fafc; border-bottom: 1px solid #e2e8f0;">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold mb-1 text-gray-900">{{ __('Order Details') }}</h1>
                        <p class="text-base text-gray-600">{{ __('Order') }} #{{ $order->code }}</p>
                        <p class="text-xs mt-1 text-gray-500">{{ $order->created_at->format('F d, Y \a\t g:i A') }}</p>
                    </div>
                    <div class="text-right">
                        @php
                            $statusColor = config('backend.colors')[$order->status] ?? '#f0f0f0';
                        @endphp
                        <div class="flex space-x-2">
                            <div class="rounded-lg px-3 py-2 bg-gray-100 border border-gray-200">
                                <div class="text-xs font-medium text-gray-600">{{ __('Status') }}</div>
                                <div class="text-gray-900 text-sm font-bold">{{ ucfirst($order->status) }}</div>
                            </div>
                            <div class="rounded-lg px-3 py-2 bg-gray-100 border border-gray-200">
                                <div class="text-xs font-medium text-gray-600">{{ __('Payment') }}</div>
                                <div class="text-gray-900 text-sm font-bold">{{ ucfirst($order->payment_status) }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- order summary card --}}
            <div class="p-4">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="relative">
                            @if ($order->vendor)
                                <img src="{{ $order->Vendor->logo }}" alt="" class="w-16 h-16 rounded-xl object-cover border-2 border-white">
                            @else
                                <img src="{{ $order->taxi_order->vehicle_type->photo }}" alt="Product image"
                                    class="w-16 h-16 rounded-xl object-cover border-2 border-white">
                            @endif
                            <div class="absolute -bottom-1 -right-1 text-white text-xs font-bold px-1 py-1 rounded-full" style="background: #2563eb;">
                                <x-heroicon-s-check-circle class="w-3 h-3" />
                            </div>
                        </div>
                        <div class="ml-4">
                            @if ($order->vendor)
                                <h2 class="text-lg font-bold text-gray-900 mb-1">{{ $order->vendor->name }}</h2>
                                @if ($order->products && $order->products->count() > 0)
                                    <div class="text-gray-600 text-sm mb-1">
                                        @php
                                            $orderProducts = $order->products;
                                            $productNames = [];
                                            foreach ($orderProducts as $orderProduct) {
                                                $productNames[] = $orderProduct->product->name;
                                            }
                                            $flattenProductName = implode(', ', $productNames);
                                        @endphp
                                        {{ Str::limit($flattenProductName, 60) }}
                                    </div>
                                @elseif ($order->order_service)
                                    <div class="text-gray-600 text-sm mb-1">
                                        {{ $order->order_service->service->name }}
                                    </div>
                                @endif
                            @else
                                <h2 class="text-lg font-bold text-gray-900 mb-1">{{ $order->taxi_order->vehicle_type->name }}</h2>
                                <div class="text-gray-600 text-sm mb-1">{{ __('Taxi Order') }}</div>
                            @endif
                            <div class="flex items-center text-gray-500 text-xs">
                                <x-heroicon-o-clock class="w-3 h-3 mr-1" />
                                {{ __('Placed on') }} {{ $order->created_at->format('F d, Y \a\t g:i A') }}
                            </div>
                        </div>
                    </div>
                    <div class="text-right">
                        <div class="text-gray-500 text-xs font-medium mb-1">{{ __('Total Amount') }}</div>
                        <div class="text-2xl font-bold" style="color: #2563eb;">{{ currencyFormat($order->total) }}</div>
                    </div>
                </div>
            </div>
        </div>

        {{-- verification code section --}}
        @if($order->verification_code)
            <div class="bg-white rounded-2xl border border-gray-200 overflow-hidden mb-4">
                <div class="px-4 py-3" style="background: #f0fdf4; border-bottom: 1px solid #dcfce7;">
                    <div class="flex items-center">
                        <div class="rounded-full p-2 mr-3 bg-green-100 border border-green-200">
                            <x-heroicon-o-shield-check class="w-5 h-5 text-green-600" />
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-gray-900 mb-0">{{ __('Order Verification Code') }}</h3>
                            <p class="text-gray-600 text-sm">{{ __('Show this code to the vendor for order verification') }}</p>
                        </div>
                    </div>
                </div>
                <div class="p-4">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <div class="rounded-xl p-4 border-2 border-dashed border-gray-300" style="background: linear-gradient(135deg, #f9fafb 0%, #f3f4f6 100%);">
                                <div class="text-center">
                                    <div class="text-xs text-gray-500 mb-1 uppercase tracking-wide font-medium">{{ __('Verification Code') }}</div>
                                    <div class="font-mono text-2xl font-bold text-gray-900 tracking-wider">
                                        {{ $order->verification_code }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="ml-4 text-center">
                            <div class="p-2 rounded-xl border-2 border-gray-200" style="background: linear-gradient(135deg, #f9fafb 0%, #ffffff 100%);">
                                <img src="{{ (new \chillerlan\QRCode\QRCode())->render($order->verification_code ?? '') }}"
                                     alt="{{ __('QR Code') }}" class="w-24 h-24 mx-auto rounded-lg" />
                            </div>
                            <p class="mt-1 text-xs text-gray-600 font-medium">{{ __('QR Code') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        {{-- pay button if needed --}}
        @if (
            !in_array($order->status, ['failed', 'cancelled']) &&
                $order->payment_status == 'pending' &&
                !empty($order->payment_link) &&
                $order->payment_method->slug != 'cash')
            <div class="bg-white rounded-2xl border border-gray-200 overflow-hidden mb-4">
                <div class="px-4 py-3" style="background: #fefbf3; border-bottom: 1px solid #fde68a;">
                    <div class="flex items-center">
                        <div class="rounded-full p-2 mr-3 bg-yellow-100 border border-yellow-200">
                            <x-heroicon-o-exclamation class="w-5 h-5 text-yellow-600" />
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-gray-900 mb-0">{{ __('Payment Required') }}</h3>
                            <p class="text-gray-600 text-sm">{{ __('Complete your payment to process this order') }}</p>
                        </div>
                    </div>
                </div>
                <div class="p-4 text-center">
                    <a href="{{ $order->payment_link }}"
                        class="inline-flex items-center px-6 py-3 space-x-2 text-base font-bold text-white rounded-xl hover:opacity-90 transition-all duration-200" style="background: #2563eb;">
                        <x-heroicon-o-credit-card class="w-5 h-5" />
                        <span>{{ __('Complete Payment') }}</span>
                    </a>
                </div>
            </div>
        @endif

        {{-- detailed order information --}}
        <div class="bg-white rounded-2xl border border-gray-200 overflow-hidden mb-4">
            <div class="px-4 py-3" style="background: #f9fafb; border-bottom: 1px solid #e5e7eb;">
                <div class="flex items-center">
                    <div class="rounded-full p-2 mr-3 bg-gray-100 border border-gray-200">
                        <x-heroicon-o-document-text class="w-5 h-5 text-gray-600" />
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-gray-900 mb-0">{{ __('Order Information') }}</h3>
                        <p class="text-gray-600 text-sm">{{ __('Complete information about your order') }}</p>
                    </div>
                </div>
            </div>
            <div class="p-4">
                @switch($order->order_type)
                    @case('package')
                        @include('livewire.order.package_order_details', [
                            'selectedModel' => $order,
                        ])
                    @break

                    @case('parcel')
                        @include('livewire.order.package_order_details', [
                            'selectedModel' => $order,
                        ])
                    @break

                    @case('service')
                        @include('livewire.order.service_order_details', [
                            'selectedModel' => $order,
                        ])
                    @break

                    @case('taxi')
                        @include('livewire.order.taxi_order_details', [
                            'selectedModel' => $order,
                        ])
                    @break

                    @default
                        @include('livewire.order.regular_order_details', [
                            'selectedModel' => $order,
                        ])
                    @break
                @endswitch
            </div>
        </div>

        {{-- back to orders button --}}
        <div class="text-center mt-2">
            <a href="{{ route('glover-website.orders') }}"
                class="inline-flex items-center px-4 py-2 space-x-2 text-gray-600 bg-white rounded-xl hover:text-gray-800 hover:bg-gray-50 border border-gray-200 transition-all duration-200 text-sm">
                <x-heroicon-o-arrow-left class="w-4 h-4" />
                <span class="font-medium">{{ __('Back to Orders') }}</span>
            </a>
        </div>
    </div>
</div>