@section('title', __('Profile'))
<div class="mb-20">
    {{-- breadcrumb --}}
    @include('livewire.extensions.glover-website.components.nav-breadcrumb', [
        'links' => [
            [
                'title' => __('Home'),
                'url' => route('glover-website.index'),
            ],
            [
                'title' => __('Profile'),
                'url' => '',
            ],
        ],
    ])


    <div class="bg-white rounded-sm p-4 shadow-sm border-gray-100">
        {{-- header --}}
        <div class="mt-2 mb-4">
            <div class="font-semibold text-lg">{{ __('My Profile') }}</div>
            <div class="text-gray-500 text-sm">{{ __('Account Details') }}</div>
        </div>
        {{-- tab for info and edit --}}
        <x-tab.tabview>

            <x-slot name="header">
                <x-tab.header tab="1" title="{{ __('Profile Details') }}" />
                <x-tab.header tab="2" title="{{ __('Edit Profile') }}" />
                <x-tab.header tab="3" title="{{ __('Change Password') }}" />
                <x-tab.header tab="4" title="{{ __('Referrals') }}" />
            </x-slot>

            <x-slot name="body">
                <x-tab.body tab="1">

                    <div class="bg-white rounded-lg  p-4">
                        <!-- User Basic Info with Avatar -->
                        <div class="flex items-center space-x-4 mb-6">
                            @if ($user->photo)
                                <img src="{{ $user->photo }}" alt="{{ $user->name }}"
                                    class="w-16 h-16 rounded-full object-cover">
                            @else
                                <div class="w-16 h-16 rounded-full bg-gray-200 flex items-center justify-center">
                                    <span
                                        class="text-xl font-semibold text-gray-500">{{ substr($user->name, 0, 1) }}</span>
                                </div>
                            @endif
                            <div>
                                <h2 class="text-xl font-bold">{{ $user->name }}</h2>
                                <p class="text-gray-500">{{ $user->email }}</p>
                            </div>
                        </div>

                        <!-- Information Cards -->
                        <div class="space-y-4">
                            <!-- Personal Information -->
                            <div class="border border-gray-100 rounded-md p-4">
                                <h3 class="font-semibold text-gray-800 mb-3">{{ __('Personal Information') }}</h3>
                                <div class="grid grid-cols-3 gap-y-3">
                                    <div class="col-span-1 text-gray-600">{{ __('Name') }}</div>
                                    <div class="col-span-2 text-gray-800">{{ $user->name }}</div>

                                    <div class="col-span-1 text-gray-600">{{ __('Email') }}</div>
                                    <div class="col-span-2 text-gray-800">{{ $user->email }}</div>

                                    <div class="col-span-1 text-gray-600">{{ __('Phone') }}</div>
                                    <div class="col-span-2 text-gray-800">
                                        {{ $user->phone ?: __('Not provided') }}
                                    </div>
                                    <div class="col-span-1 text-gray-600">{{ __('Joined On') }}</div>
                                    <div class="col-span-2 text-gray-800">
                                        {{ $user->created_at->format('M d, Y') }}
                                    </div>
                                </div>
                            </div>

                            <!-- Order Information -->
                            <div class="border border-gray-100 rounded-md p-4">
                                <h3 class="font-semibold text-gray-800 mb-3">{{ __('Order Information') }}</h3>
                                <div class="grid grid-cols-3 gap-y-3">
                                    @php
                                        $totalOrders = \App\Models\Order::where('user_id', $user->id)->count();
                                        $lastOrder = \App\Models\Order::where('user_id', $user->id)->latest()->first();
                                    @endphp

                                    <div class="col-span-1 text-gray-600">{{ __('Total Orders') }}</div>
                                    <div class="col-span-2 text-gray-800">{{ $totalOrders }}</div>

                                    <div class="col-span-1 text-gray-600">{{ __('Last Order') }}</div>
                                    <div class="col-span-2 text-gray-800">
                                        @if ($lastOrder)
                                            {{ $lastOrder->created_at->format('M d, Y H:i a') }}
                                        @else
                                            {{ __('No orders yet') }}
                                        @endif
                                    </div>

                                    @if ($lastOrder)
                                        <div class="col-span-1 text-gray-600">{{ __('Last Order Total') }}</div>
                                        <div class="col-span-2 text-gray-800">
                                            {{ currencyFormat($lastOrder->total) }}</div>
                                    @endif
                                </div>
                            </div>

                        </div>
                    </div>

                </x-tab.body>
                <x-tab.body tab="2">
                    <div class="w-full md:w-6/12 lg:w-4/12">
                        <form wire:submit.prevent="updateProfile">
                            <x-input name="photo" title="{{ __('Photo') }}" type="file" accept="image/*" />
                            <x-input name="name" title="{{ __('Name') }}" />
                            <x-input name="email" title="{{ __('Email Address') }}" />
                            <x-phoneselector />
                            <div class="flex justify-end mt-4">
                                <x-buttons.primary title="{{ __('Update Profile') }}" />
                            </div>
                        </form>
                    </div>
                </x-tab.body>
                <x-tab.body tab="3">
                    <div class="w-full md:w-6/12 lg:w-4/12">
                        <form wire:submit.prevent="changePassword">
                            <x-input type="password" name="current_password" title="{{ __('Current Password') }}" />
                            <x-input type="password" name="new_password" title="{{ __('New Password') }}" />
                            <x-input type="password" name="new_password_confirmation"
                                title="{{ __('Confirm New Password') }}" />

                            <div class="flex justify-end mt-4">
                                <x-buttons.primary title="{{ __('Change Password') }}" />
                            </div>
                        </form>
                    </div>
                </x-tab.body>
                <x-tab.body tab="4">
                    <!-- Referral section Statistics -->
                    @if ((bool) setting('enableReferSystem'))
                        @php
                            $referRewardAmount = currencyFormat((float) setting('referRewardAmount'));
                            $totalReferrals = method_exists($user, 'myReferrals')
                                ? $user->myReferrals()->count()
                                : $user->hasMany(\App\Models\Referral::class, 'user_id')->count();
                        @endphp
                        <div class="border border-gray-100 rounded-md p-4">
                            <h3 class="font-semibold text-gray-800 mb-3">{{ __('Referral') }}</h3>
                            <div class="grid grid-cols-3 gap-y-3">
                                <div class="col-span-1 text-gray-600">{{ __('Your Code') }}</div>
                                <div class="col-span-2 text-gray-800">
                                    <span class="inline-flex items-center">
                                        {{ $user->code ?? 'Not generated' }}
                                        @if ($user->code)
                                            <button onclick="copyToClipboard('{{ $user->code }}')"
                                                class="ml-2 text-blue-600 hover:text-blue-800">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor"
                                                    viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        stroke-width="2"
                                                        d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z">
                                                    </path>
                                                </svg>
                                            </button>
                                        @endif
                                    </span>
                                </div>

                                <div class="col-span-1 text-gray-600">{{ __('Total Referrals') }}</div>
                                <div class="col-span-2 text-gray-800">{{ $totalReferrals }}</div>

                                <div class="col-span-1 text-gray-600">{{ __('Reward Amount') }}</div>
                                <div class="col-span-2 text-gray-800">
                                    {{ $referRewardAmount }}
                                    {{ __('per successful referral') }}
                                </div>
                                <div class="col-span-1 text-gray-600">{{ __('Est. Earned Rewards') }}</div>
                                <div class="col-span-2 text-gray-800">
                                    {{ currencyFormat($totalReferrals * (float) setting('referRewardAmount')) }}
                                </div>
                            </div>

                            <div class="mt-4">
                                <div class="text-sm text-gray-600 mb-2">{{ __('Share Your Referral Link') }}
                                </div>
                                <div class="flex items-center">
                                    <input type="text" readonly
                                        value="{{ route('glover-website.register') }}?ref={{ $user->code }}"
                                        class="flex-1 border border-gray-300 rounded-l-md px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-transparent"
                                        id="referralLink">
                                    <button onclick="copyToClipboard('referralLink')"
                                        class="bg-primary-600 text-theme px-3 py-2 rounded-r-md hover:bg-primary-700 text-sm">
                                        {{ __('Copy') }}
                                    </button>
                                </div>
                            </div>
                        </div>
                    @endif
                </x-tab.body>
            </x-slot>
        </x-tab.tabview>

    </div>

</div>
@include('layouts.partials.phoneselector')
@push('styles')
    <style>
        .iti {
            width: 100%;
        }

        .intl-tel-input {
            width: 100%;
        }
    </style>
@endpush
@push('scripts')
    <script>
        function copyToClipboard(textOrElementId) {
            let text;
            if (document.getElementById(textOrElementId)) {
                // If it's an element ID
                text = document.getElementById(textOrElementId).value;
            } else {
                // If it's plain text
                text = textOrElementId;
            }

            navigator.clipboard.writeText(text).then(() => {
                // You could show a tooltip or notification here
                alert({{ __('Copied to clipboard!') }});
            }).catch(err => {
                console.error('Failed to copy: ', err);
            });
        }
    </script>
@endpush
