@section('title', $vendorType->name)
<div class="mb-20">
    {{-- breadcrumb --}}
    @include('livewire.extensions.glover-website.components.nav-breadcrumb', [
        'links' => [
            [
                'title' => __('Home'),
                'url' => route('glover-website.index'),
            ],
            [
                'title' => $vendorType->name,
                'url' => '',
            ],
        ],
    ])

    <div class="space-y-6 w-full">

        {{-- banner for small screen --}}
        <div class="block md:hidden">
            <livewire:extensions.glover-website.components.banner-slider vendor_type_id="{{ $vendorType->id }}"
                eId="sm-slider" />
        </div>
        {{-- banners --}}
        <div class="hidden md:block">
            <livewire:extensions.glover-website.components.banner-slider vendor_type_id="{{ $vendorType->id }}"
                eId="lg-slider" />
        </div>

        {{-- categories --}}
        <livewire:extensions.glover-website.components.categories id="{{ $vendorType->id }}" axis="horizontal" />

        {{-- popular foods nearby --}}
        <livewire:extensions.glover-website.components.popular-nearby-products vendor_type_id="{{ $vendorType->id }}"
            title="{{ __('Best Selling') }}" showEmpty="1" />

        {{-- new products --}}
        <livewire:extensions.glover-website.components.newest-products vendor_type_id="{{ $vendorType->id }}"
            title="{{ __('NEW PRODUCTS') }}" subtitle="{{ __('New products with updated stocks.') }}" showEmpty="0" />

        {{-- campaign products --}}
        <livewire:extensions.glover-website.components.campaign-products vendor_type_id="{{ $vendorType->id }}" />



        {{-- popular vendors --}}
        <livewire:extensions.glover-website.components.popular-vendors vendor_type_id="{{ $vendorType->id }}" />

        {{-- all vendors --}}
        <livewire:extensions.glover-website.components.all-vendors vendor_type_id="{{ $vendorType->id }}"
            title="{{ __('All Vendors') }}" showEmpty="0" />

    </div>
</div>
