@section('title', __('New Taxi Order'))
<div>

    <div class="w-full grid grid-cols-1 md:grid-cols-5 md:gap-4">
        <div class="col-span-3 rounded bg-white p-4 shadow pb-12">
            <x-baseview title="{{ __('New Taxi Order') }}">

                <div class="grid grid-cols-1 gap-4">

                    {{-- payment method --}}
                    <x-label title="{{ __('Payment Method') }}">
                        <livewire:select.payment-method-select name="payment_method_id"
                            placeholder="-- {{ __('Select') }} --" />
                    </x-label>

                    {{-- pickup address --}}
                    <x-label title="{{ __('Pickup Address') }}">
                        <livewire:select.address-search-select name="pickup_address" :searchable="true"
                            placeholder="{{ __('Enter address, place etc.') }}" />
                    </x-label>

                    {{-- dropoff address --}}
                    <x-label title="{{ __('Dropoff Address') }}">
                        <livewire:select.address-search-select name="dropoff_address" :searchable="true"
                            placeholder="{{ __('Enter address, place etc.') }}" />
                    </x-label>

                    {{-- vehicle types --}}
                    <x-label title="{{ __('Vehicle Type') }}">
                        <livewire:select.vehicle-type-select name="vehcile_type_id" />
                    </x-label>
                </div>

            </x-baseview>
        </div>
        <div class="col-span-2 rounded bg-white p-4 shadow">
            <p class="font-medium text-2xl">{{ __('Order Summary') }}</p>
            <hr class="my-4" />
            <x-details.item title="{{ __('Pickup Address') }}"
                text="{{ $pickup_address['formatted_address'] ?? '' }}" />
            <x-details.item title="{{ __('Dropoff Address') }}"
                text="{{ $dropoff_address['formatted_address'] ?? '' }}" />
            <x-details.item title="{{ __('Vehicle Type') }}" text="{{ $vehicleType->name ?? '' }}" />
            <hr class="my-4" />
            {{-- amounts --}}
            <div class="font-bold text-lg">
                <div class="flex justify-between">
                    <p class="text-lg font-normal">{{ __('Subtotal') }}</p>
                    <p class="">{{ currencyFormat($amount ?? 0.0) }}</p>
                </div>
                <div class="flex justify-between">
                    <p class="text-lg font-normal">{{ __('Discount') }}</p>
                    <p class="">- {{ currencyFormat($discount ?? 0.0) }}</p>
                </div>
                <hr class="my-4" />
                <div class="flex justify-between">
                    <p class="text-lg font-normal">{{ __('Total') }}</p>
                    <p class="">{{ currencyFormat($total_amount ?? 0.0) }}</p>
                </div>
                <hr class="my-4" />
                {{-- create order button --}}
                <div class="flex justify-end">
                    <x-buttons.primary wireClick="createOrder">
                        {{ __('Create Order') }}
                    </x-buttons.primary>
                </div>
            </div>
        </div>
    </div>

</div>
@push('scripts')
    <script>
        /**
                 * Get user's current location with address details
                 * @param {Function} onSuccess - Callback function when location is successfully retrieved
                 * @param {Function} onError - Callback function when an error occurs

                    */
        function getCurrentLocation(onSuccess, onError) {
            // Check if geolocation is supported by the browser
            if (!navigator.geolocation) {
                if (onError) {
                    onError({
                        code: 0,
                        message: "{{ __('Geolocation is not supported by your browser') }}"
                    });
                }
                return;
            }

            // Options for geolocation request
            const options = {
                enableHighAccuracy: true, // Use GPS if available
                timeout: 5000, // Time to wait before error (10 seconds)
                maximumAge: 0 // Don't use a cached position
            };

            // Success handler
            function success(position) {
                const latitude = position.coords.latitude;
                const longitude = position.coords.longitude;
                const accuracy = position.coords.accuracy;

                // If we only need coordinates, return them directly
                if (onSuccess) {
                    onSuccess({
                        latitude,
                        longitude,
                        accuracy,
                        address: null
                    });
                }
                return;


            }

            // Error handler
            function error(err) {
                const errorMessages = {
                    1: "{{ __('User denied the request for geolocation') }}",
                    2: "{{ __('Location information is unavailable') }}",
                    3: "{{ __('The request to get user location timed out') }}",
                };

                const message = errorMessages[err.code] || "An unknown error occurred";

                if (onError) {
                    onError({
                        code: err.code,
                        message: message
                    });
                }
            }

            // Request location
            navigator.geolocation.getCurrentPosition(success, error, options);
        }

        // Example usage:
        // Add a button to your page: <button id="get-location-btn">Get My Location</button>
        document.addEventListener('DOMContentLoaded', function() {

            getCurrentLocation(
                function(locationData) {
                    console.log('Location:', locationData.latitude, locationData.longitude);
                    console.log('Address:', locationData.address);
                    livewire.emit("autoPickupAddressSelected", locationData.latitude, locationData.longitude)
                },
                function(error) {
                    console.error('Error:', error.message);
                }
            );
        });
    </script>
@endpush
